<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('county', 'company_address_2', 'company_state', 'company_number_employees', 'business_type_id');
    protected $visible = array('county', 'company_address_2', 'company_state', 'company_number_employees', 'business_type_id');

    public function counties()
    {
        return $this->hasOne('App\Models\County', 'county_id');
    }

    public function insurance()
    {
        return $this->hasMany('App\Models\CompanyInsurance', 'company_id');
    }

    public function internal_company_profiles()
    {
        return $this->hasMany('App\Models\InternalCompanyProfile', 'company_id');
    }

    public function business_type()
    {
        return $this->hasOne('App\Models\BusinessType', 'business_type');
    }

    public function business_type()
    {
        return $this->hasOne('App\Models\BusinessType', 'business_type_id');
    }

}